<?php
// -*- coding: utf-8 -*-
//
//  Web Application - neo-installer
//
//  Copyright (c) nkd. 2008
//
//  $Id: neo_install_system.php,v 1.1 2008/03/20 9:22:15 nkd Exp $
//
ini_set('default_charset', 'UTF-8');
ini_set('mbstring.language','Japanese');
ini_set('mbstring.internal_encoding','UTF-8');
ini_set('mbstring.http_output','UTF-8');
ini_set('mbstring.substitute_character','none');
ini_set('mbstring.detect_order','auto');
ini_set('magic_quotes_gpc','0');
ini_set('mbstring.encoding_translation','1');
ini_set('mbstring.http_input','auto');

error_reporting(E_ERROR | E_WARNING | E_PARSE);
//error_reporting(0);
set_magic_quotes_runtime(0);

session_set_cookie_params(0, '/');
session_start();

define('DL_URL','http://www.mail-neo.com/downloads/targz/%s/%s/%s');
define('TAR_FILE','neo.tar.gz');
define('TAR_FILE2','neo.tar');
define('SOURCE_DIR','neo');
define('LOADER_DL_URL','http://www.mail-neo.com/downloads/ioncube/%s');
define('LOADER_TAR_FILE','ioncube.tar.gz');
define('LOADER_TAR_FILE2','ioncube.tar');
define('LOADER_SOURCE_DIR','ioncube');

define('SQLDIR','backend/database');
define('DBCONFFILE','backend/lib/config/database.php');
define('VERFILE','backend/lib/config/verup.php');

define('REG_URL','http://www.mail-neo.com/servers/reg/%s');

if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

define('INSTALLER_PHP','neo_install_system.php');
define('INDEX_HTML','neo.html');

if(isset($_GET['sysinfo'])){
	if($_GET['sysinfo']=='phpinfo'){
		echo phpinfo();
	}
	exit;
}

$ni=new neoinst();

showHeader();
if(isset($_POST['act']) && $_POST['act']=='dl'){
	if(!fileSetting()){
		showFooter();
		exit;
	}
	regist(18);
	if(!setPerm()){
		showFooter();
		exit;
	}
	showInput();
}else if(isset($_POST['act']) && $_POST['act']=='setdb'){
	if(!$ni->setDb()){
		showFooter();
		exit;
	}
	makePhpIni($_SESSION['servername']);
	regist(17,$_SESSION['servername'],$_SESSION['servertype']);
	if(!installLoader()){
		showFooter();
		exit;
	}
	copyLoader();
	regist(16,$_SESSION['servername'],$_SESSION['servertype']);
	if(!checkLoader()){
		showLoderErr();
		regist(15,$_SESSION['servername'],$_SESSION['servertype']);
	}else{
		showEnd();
		regist(10,$_SESSION['servername'],$_SESSION['servertype']);
	}
}else if(isset($_GET['act']) && $_GET['act']=='ld'){
	if(isset($_GET['system'])){
		if(!installLoader($_GET['system'])){
			showFooter();
			exit;
		}
		copyLoader();
		if(!checkLoader()){
			showLoderNG();
		}else{
			showLoderOK();
			regist(10,$_SESSION['servername'],$_SESSION['servertype']);
		}
	}else{
		showLoaderList();
	}
}else{
	regist();
	if(!setDir()){
		showFooter();
		exit;
	}
	if(!checkParm()){
		showFooter();
		exit;
	}
	if(!checkEnv()){
		showFooter();
		exit;
	}
	showInputIdPw();
	regist(19);
}
showFooter();
exit;


/*
 * 関数
 */

function setDir(){
	if(isset($_GET['dir'])){
		$dirname=$_GET['dir'];
		if(!preg_match("/^[0-9a-zA-Z]+$/",$dirname)) {
			showError('ディレクトリ名は半角英数字にしてください。');
			return false;
		}
		$_SESSION['dirname']=$dirname;
	}else{
//		$_SESSION['dirname']='.';
		$_SESSION['dirname']='neo';
	}
	return true;
}

function showHeader(){
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>システムのインストール</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<script language="javascript">
	var stripe = function() {
		var tables = document.getElementsByTagName("table");

		for(var x=0;x!=tables.length;x++){
			var table = tables[x];
			if (! table) { return; }

			var tbodies = table.getElementsByTagName("tbody");

			for (var h = 0; h < tbodies.length; h++) {
				var even = true;
				var trs = tbodies[h].getElementsByTagName("tr");

				for (var i = 0; i < trs.length; i++) {
					trs[i].onmouseover=function(){
						this.className += " ruled"; return false
					}
					trs[i].onmouseout=function(){
						this.className = this.className.replace("ruled", ""); return false
					}

					if(even)
						trs[i].className += " even";

					even = !even;
				}
			}
		}
	}

	window.onload = stripe;
</script>
<style>
*{ margin:0;padding:0;}

body{
font-family:"frutiger linotype","lucida grande",helvetica,arial,sans-serif;
text-align:center;
color:#333;
font-size: 76%;
}

/* General Style Info */
a{
color:#003d4c;
text-decoration:underline;
}
a:hover{
color:#003d4c;
text-decoration:none;
}

h2 {
	font-family:verdana, arial, helvetica, Sans-Serif;
	color:inherit;
	background-color:#DDEEFF;
	padding:.3em;
	border:0px;
	margin:0px 0px .5em 0px;
}
h3 {
	font-family:verdana, arial, helvetica, Sans-Serif;
	border-bottom:  3px solid #DDEEFF;
	border-top:     1px solid #DDEEFF;
	border-left:   10px solid #DDEEFF;
	border-right:   5px solid #DDEEFF;

	color:inherit;
	background-color:#FFFFFF;
	padding:.3em;
	margin:0px 0px .5em 0px;
}

#container{
text-align:left;
}

#content{
clear:both;
padding: 20px 40px 10px 40px;
background-color: #fff;
color: #333;
}

/* tables */
table {
width: 100%;
border-top: 1px solid #ccc;
border-left: 1px solid #ccc;
border-bottom: 1px solid #ccc;
color:#333;
background-color: #fff;
clear:both;
padding: 0;
margin: 0 0 2em 0;
white-space: normal;
}
th {
background-color: #e2e2e2;
border-top: 1px solid #fff;
border-left: 1px solid #fff;
border-right: 1px solid #003d4c;
border-bottom: 1px solid #003d4c;
text-align: center;
padding:1px 4px;
}
table tr td {
border-right: 1px solid #ddd;
padding:4px 4px;
vertical-align:top;
#text-align: center;
}
table tr.altRow td {
background: #f4f4f4;
}
table tr { background-color: #FAFAFA; }
.even { background-color: #E8EEF7; }
</style>
</head>
<body>
	<div id="container">
		<div id="content">
<?php
}

function showFooter(){
?>
<br />
<br />

		</div>
	</div>
</body>
</html>

<?php
}

function showError($str) {
?>

<h3>エラー</h3>

<?php echo $str; ?>
<br>
<br>
<?php
}

function checkParm()
{
	clearstatcache();
	if($_SESSION['dirname'] == '.'){
		$parm=substr(sprintf('%o', fileperms($_SESSION['dirname'])), -3);
		if($parm!='777')
		{
			showError('このファイルを設置したフォルダのパーミッションを777に変更してください。');
			return false;
		}
	}else{
		if(!file_exists($_SESSION['dirname'])){
			if(!@mkdir($_SESSION['dirname'], 0755)){
				showError('このファイルを設置したフォルダに '.$_SESSION['dirname'].' というフォルダを作成し、パーミッションを777に変更してください。');
				return false;
			}
		}else{
			$parm=substr(sprintf('%o', fileperms($_SESSION['dirname'])), -3);
			if($parm!='777')
			{
				showError('このファイルと同じ階層にある「'.$_SESSION['dirname'].'」というフォルダのパーミッションを777に変更してください。');
				return false;
			}
		}
	}
	return true;
}

function checkSafeMode(){
	$sm = ini_get('safe_mode');
	return ($sm=='1');
}

function regist($result=20,$name='no name',$servertype=0) {
	$key=time();
	$data=array(
						'n'=>$name,
						'o'=>substr(php_uname(),0,strpos(php_uname(),' ')),
						'v'=>phpversion(),
						'i'=>gethostbyname(php_uname('n')),
						's'=>php_uname('n'),
						'r'=>$result,
						't'=>$servertype,
						);
	$hash=md5($key.serialize($data));
	$vars=urlencode(serialize(array('key'=>$key,'data'=>$data,'hash'=>$hash)));
	$regurl=sprintf(REG_URL,$vars);
	$re=@join('',@file($regurl));
 	return ($re!='' && $re==0)?false:true;
}

function download ($file_source, $file_target){
	$allow_url_fopen=ini_get('allow_url_fopen');
	if(!empty($allow_url_fopen)) {
	  // Preparations
	  $file_source = str_replace(' ', '%20', html_entity_decode($file_source)); // fix url format
	  if (file_exists($file_target)) { chmod($file_target, 0777); } // add write permission

	  // Begin transfer
	  if (($rh = fopen($file_source, 'rb')) === FALSE) { return false; } // fopen() handles
	  if (($wh = fopen($file_target, 'wb')) === FALSE) { return false; } // error messages.
	  while (!feof($rh)){
	    // unable to write to file, possibly because the harddrive has filled up
	    if (fwrite($wh, fread($rh, 1024)) === FALSE) { fclose($rh); fclose($wh); return false; }
	  }

	  // Finished without errors
	  fclose($rh);
	  fclose($wh);
	  return true;
	}else{
		$r = new HTTPRequest($file_source);
		file_put_contents($file_target, $r->DownloadToString());
	}
}


if (!function_exists('file_put_contents')) {
	function file_put_contents($fileName, $data) {
		if (is_array($data)) {
			$data = join('', $data);
		}
		$res = @fopen($fileName, 'w+b');
		if ($res) {
			$write = @fwrite($res, $data);
			if($write === false) {
				return false;
			} else {
				return $write;
			}
		}
	}
}

class HTTPRequest
{
    var $_fp;        // HTTP socket
    var $_url;        // full URL
    var $_host;        // HTTP host
    var $_protocol;    // protocol (HTTP/HTTPS)
    var $_uri;        // request URI
    var $_port;        // port

    // scan url
    function _scan_url()
    {
        $req = $this->_url;

        $pos = strpos($req, '://');
        $this->_protocol = strtolower(substr($req, 0, $pos));

        $req = substr($req, $pos+3);
        $pos = strpos($req, '/');
        if($pos === false)
            $pos = strlen($req);
        $host = substr($req, 0, $pos);

        if(strpos($host, ':') !== false)
        {
            list($this->_host, $this->_port) = explode(':', $host);
        }
        else
        {
            $this->_host = $host;
            $this->_port = ($this->_protocol == 'https') ? 443 : 80;
        }

        $this->_uri = substr($req, $pos);
        if($this->_uri == '')
            $this->_uri = '/';
    }

    // constructor
    function HTTPRequest($url)
    {
        $this->_url = $url;
        $this->_scan_url();
    }

    // download URL to string
    function DownloadToString()
    {
        $crlf = "\r\n";
        $response = '';

        // generate request
        $req = 'GET ' . $this->_uri . ' HTTP/1.0' . $crlf
            .    'Host: ' . $this->_host . $crlf
            .    $crlf;

        // fetch
        $this->_fp = fsockopen(($this->_protocol == 'https' ? 'ssl://' : '') . $this->_host, $this->_port);
        fwrite($this->_fp, $req);
        while(is_resource($this->_fp) && $this->_fp && !feof($this->_fp))
            $response .= fread($this->_fp, 1024);
        fclose($this->_fp);

        // split header and body
        $pos = strpos($response, $crlf . $crlf);
        if($pos === false)
            return($response);
        $header = substr($response, 0, $pos);
        $body = substr($response, $pos + 2 * strlen($crlf));

        // parse headers
        $headers = array();
        $lines = explode($crlf, $header);
        foreach($lines as $line)
            if(($pos = strpos($line, ':')) !== false)
                $headers[strtolower(trim(substr($line, 0, $pos)))] = trim(substr($line, $pos+1));

        // redirection?
        if(isset($headers['location']))
        {
            $http = new HTTPRequest($headers['location']);
            return($http->DownloadToString($http));
        }
        else
        {
            return($body);
        }
    }
}

function checkLoader() {
	if($_SESSION['dirname'] == '.'){
		$dir=dirname(__FILE__);
	}else{
		$dir=dirname(__FILE__).'/'.$_SESSION['dirname'];
	}
//	if(file_exists($dir.'/ioncube')){
//		$phpfile =$_SESSION['dirname'].'/ioncube/ioncube-loader-helper.php';
//	}	else {
//		$phpfile =$_SESSION['dirname'].'/ioncube-loader-helper.php';
//	}
	$phpfile =$_SESSION['dirname'].'/test/ioncube-test.php';

	$path=str_replace(INSTALLER_PHP,"",env('SCRIPT_NAME')).$phpfile;
	if(!env('HTTPS')){
		$re=@join('',@file('http://'.env('SERVER_NAME').$path));
	}else{
		$re=@join('',@file('https://'.env('SERVER_NAME').$path));
	}
//	return (strpos($re,'<font color=green>successfully</font>')!==false)?true:false;
	return (strpos($re,'IONCUBE LOADER TEST OK')!==false)?true:false;
}

function copyLoader(){
	$match = explode('.', phpversion());
	$phpver = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));
	if($phpver>=50205){
		$dir=dirname(__FILE__).'/'.$_SESSION['dirname'];
		$cmd=sprintf('cp %s/ioncube_loader_* %s/test/',$dir,$dir);
		system($cmd);
		$cmd=sprintf('cp %s/ioncube_loader_* %s/backend/mail/bin/',$dir,$dir);
		system($cmd);
	}
}

function checkEnv(){
	$os_name = substr(php_uname(),0,strpos(php_uname(),' '));
	$os_code = strtolower(substr($os_name,0,3));
	$os_info = php_uname();

	$php_version = phpversion();
	$php_flavour = substr($php_version,0,3);
	$match = explode('.', phpversion());
	$phpver = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));

	$thread_safe = false;
	$enable_dl = false;
	$extension_dir =false;
	$enable_cli=false;
	$enable_debug=false;
	$enable_versioning=false;

	ob_start();
	phpinfo(INFO_GENERAL);
	$php_info = ob_get_contents();
	ob_end_clean();

	foreach (split("\n",$php_info) as $line) {
	  if (eregi('command',$line)) {
			if(strpos($line,'--enable-cli')!==false || strpos($line,'--disable-cli')===false) {
	    	$enable_cli = true;
			}
			if(strpos($line,'--enable-debug=no')!==false || strpos($line,'--enable-debug')===false) {
	    	$enable_debug = true;
			}
			if(strpos($line,'--enable-versioning')===false) {
	    	$enable_versioning = true;
			}
	    continue;
	  }

	  if (preg_match('/Server API.*(CGI)/Ui',$line)) {
	    $_SESSION['cp_bin_file']=1;
	  }
	  if (preg_match('/thread safety.*(enabled|yes)/Ui',$line)) {
	    $thread_safe = true;
	  }
	}

	ob_start();
	phpinfo(INFO_CONFIGURATION);
	$php_info = ob_get_contents();
	ob_end_clean();

	foreach (split("\n",$php_info) as $line) {
	  if (eregi('command',$line)) {
	    continue;
	  }

	  if (preg_match('/enable_dl.*on/Ui',$line)) {
	    $enable_dl = true;
	  }

	  if (preg_match('/extension_dir<.*>\.\/</Ui',$line)) {
	    $extension_dir = true;
	  }
	}

	if($os_code=='win'){
		showError('プラットフォームがWindows系のため、このサーバーでは利用できません。');
		return false;
	}
	if($phpver>=50205 && !$extension_dir){
		showError('PHPのバージョンが5.2.5以上で、extension_dir="./"となっていないため、このサーバーでは利用できません。');
		return false;
	}
	if(!$enable_dl){
		showError('PHPのenable_dlオプションがonでないため、このサーバーでは利用できません。');
		return false;
	}
	if(!$enable_debug){
		showError('PHPのコンパイルオプションに「--enable-debug」が含まれているため、このサーバーでは利用できません。');
		return false;
	}
//	if(!$enable_versioning){
//		showError('PHPのコンパイルオプションに「--enable-versioning」が含まれているため、このサーバーでは利用できません。');
//		return false;
//	}
	if(checkSafeMode()){
		showError('PHPのsafe_modeオプションがoffでないため、このサーバーでは利用できません。');
		return false;
	}
	if(!$enable_cli){
		showError('コマンドラインでPHPを利用できないため、このサーバーでは利用できません。');
		return false;
	}
	if(!function_exists('mb_detect_encoding')){
		showError('PHPでmb_string関係の関数を利用できないため、このサーバーでは利用できません。');
		return false;
	}
	if(!function_exists('mysql_connect')){
		showError('PHPでmysql関係の関数を利用できないため、このサーバーでは利用できません。');
		return false;
	}
//	$allow_url_fopen=ini_get('allow_url_fopen');
//	if(empty($allow_url_fopen)) {
//		showError('PHPのallow_url_fopenオプションがonでないため、このサーバーでは利用できません。');
//		return false;
//	}
	return true;
}

function scanEntireDir($dir){
	$dh  = opendir($dir);
	while (false !== ($filename = readdir($dh))) {
		$files[] = $filename;
	}
	closedir($dh);
	return $files;
}

function delTree($f){
	if (is_dir($f)) {
		foreach(scanEntireDir($f) as $item){
			if ( (!strcmp($item, '.')) OR (!strcmp($item, '..')) ) continue;
			delTree($f . "/" . $item); // recurision
		}
		@rmdir($f);
	}else{
		@unlink($f);
	}

	// check if deleted?
	if (is_dir($f)) return false;
	else return true;
}

function dircopy($srcdir, $dstdir, $verbose = false) {
  $num = 0;
  if(!is_dir($dstdir)) mkdir($dstdir);
  if($curdir = opendir($srcdir)) {
    while($file = readdir($curdir)) {
      if($file != '.' && $file != '..') {
        $srcfile = $srcdir . '/' . $file;
        $dstfile = $dstdir . '/' . $file;
        if(is_file($srcfile)) {
          if(is_file($dstfile)) $ow = filemtime($srcfile) - filemtime($dstfile); else $ow = 1;
          if($ow > 0) {
            if($verbose) echo "Copying '$srcfile' to '$dstfile'...";
            if(copy($srcfile, $dstfile)) {
              touch($dstfile, filemtime($srcfile)); $num++;
              if($verbose) echo "OK\n";
            }else{
            	@unlink($dstfile);
            	if(rename($srcfile, $dstfile)) {
	              $num++;
	              if($verbose) echo "OK\n";
            	}else{
	             echo "Error: File '$srcfile' could not be copied!\n";
            	}
            }
          }
        }
        else if(is_dir($srcfile)) {
          $num += dircopy($srcfile, $dstfile, $verbose);
        }
      }
    }
    closedir($curdir);
  }
  return $num;
}

function delAll(){
	@unlink($_SESSION['dirname'].'/'.TAR_FILE);
	delTree($_SESSION['dirname'].'/'.SOURCE_DIR);
	delTree($_SESSION['dirname'].'/backend');
	delTree($_SESSION['dirname'].'/test');
	delTree($_SESSION['dirname'].'/img');
	delTree($_SESSION['dirname'].'/css');
	if(file_exists($_SESSION['dirname'].'/ioncube')){
		delTree($_SESSION['dirname'].'/ioncube');
	}
	if(file_exists($_SESSION['dirname'].'/js')){
		delTree($_SESSION['dirname'].'/js');
	}
	if(file_exists($_SESSION['dirname'].'/tmp/log')){
		delTree($_SESSION['dirname'].'/tmp/log');
	}

	foreach(scanEntireDir($_SESSION['dirname']) as $item){
		if ( (!strcmp($item, '.')) OR (!strcmp($item, '..')) OR (!strcmp($item, 'tmp'))) continue;
		@unlink($_SESSION['dirname'].'/'.$item);
	}
}

function fileSetting(){
	if (ini_get('magic_quotes_gpc') == 1) {
		if(count($_POST)) {
			$params['form'] = stripslashes_deep($_POST);
		}
	} else {
		$params['form'] = $_POST;
	}

//	if(!preg_match('/^[0-9a-zA-Z_.+-]+@[0-9a-zA-Z-]+(?:\.[0-9a-zA-Z-]+)+$/',$params['form']['email']))
//	{
//		showError('メールアドレスは正しく記入してください。');
//		return false;
//	}
//	if(!preg_match("/^\w+$/",$params['form']['password']))
//	{
//		showError('パスワードは半角英数字で記入してください。');
//		return false;
//	}

	delAll();

	$match = explode('.', phpversion());
	$phpver = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));
	if ($phpver < 50000) {
		$ver='php4';
	}else if ($phpver>=50205) {
		$ver='php525';
	}else{
		$ver='php5';
	}

//	$dlurl=sprintf(DL_URL,urlencode($params['form']['email']),$params['form']['password'],$ver);
		$dlurl=sprintf(DL_URL,'freeneo','withad',$ver);

	if(!download($dlurl,$_SESSION['dirname'].'/'.TAR_FILE)){
		showError('ファイルのダウンロードに失敗しました。しばらくしてからやりなおしてください。');
		return false;
	}

	if(!file_exists($_SESSION['dirname'].'/'.TAR_FILE)){
		showError('ファイルのダウンロードに失敗しました。しばらくしてからやりなおしてください。');
		return false;
	}

	if(filesize($_SESSION['dirname'].'/'.TAR_FILE)<100){
		showError('NEO会員ページのログイン情報が正しくありません。');
		return false;
	}

	if($_SESSION['dirname'] == '.'){
		$cmd='tar -zxf '.TAR_FILE.' '.SOURCE_DIR;
		$cmd2='gzip -d '.TAR_FILE.'; tar -xf '.TAR_FILE2;
	}else{
		$cmd='cd '.$_SESSION['dirname'].'; tar -zxf '.TAR_FILE.' '.SOURCE_DIR;
		$cmd2='cd '.$_SESSION['dirname'].'; gzip -d '.TAR_FILE.'; tar -xf '.TAR_FILE2;
	}
	$re=exe($cmd);

	if(!file_exists($_SESSION['dirname'].'/'.SOURCE_DIR)){
		$re=exe($cmd2);
		if(!file_exists($_SESSION['dirname'].'/'.SOURCE_DIR)){
			showError('ファイルの展開に失敗しました。ファイル取得に失敗した可能性があります。しばらくしてからやりなおしてください。');
			return false;
		}
	}

	@unlink($_SESSION['dirname'].'/'.TAR_FILE);
	@unlink($_SESSION['dirname'].'/'.TAR_FILE2);

//	if($php_version>='5.2.5'){
//		dircopy($_SESSION['dirname'].'/'.SOURCE_DIR.'/ioncube',$_SESSION['dirname'].'/'.SOURCE_DIR);
//		delTree($_SESSION['dirname'].'/'.SOURCE_DIR.'/ioncube/');
//	}

	dircopy($_SESSION['dirname'].'/'.SOURCE_DIR,$_SESSION['dirname']);
	delTree($_SESSION['dirname'].'/'.SOURCE_DIR);

	touchVerup();

	return true;
}

function setPerm(){
	chmod($_SESSION['dirname'].'/backend/lib/config/database.php', 0666);
	chmod($_SESSION['dirname'].'/backend/mail/bin/regist.cgi', 0755);
	chmod($_SESSION['dirname'].'/backend/mail/bin/sender.cgi', 0755);
	chmod($_SESSION['dirname'].'/backend/tmp/smarty/cache/', 0777);
	chmod($_SESSION['dirname'].'/backend/tmp/smarty/templates_c/', 0777);
	chmod($_SESSION['dirname'].'/backend/tmp/pseudo-cron/cronjobs/', 0777);
	chmod($_SESSION['dirname'].'/backend/tmp/data/', 0777);
	chmod($_SESSION['dirname'].'/tmp/log/', 0777);

	if(isset($_SESSION['cp_bin_file']) && $_SESSION['cp_bin_file']==1){
		copy($_SESSION['dirname'].'/backend/mail/src/sender.php',$_SESSION['dirname'].'/backend/mail/bin/sender.cgi');
		copy($_SESSION['dirname'].'/backend/mail/src/regist.php',$_SESSION['dirname'].'/backend/mail/bin/regist.cgi');
		rename($_SESSION['dirname'].'/backend/mail/bin/sender.cgi',$_SESSION['dirname'].'/backend/mail/bin/sender.php');
		rename($_SESSION['dirname'].'/backend/mail/bin/regist.cgi',$_SESSION['dirname'].'/backend/mail/bin/regist.php');
	}

	return true;
}

function showInputIdPw(){
?>


<h3>ファイルの取得</h3>

		<form method="post" action="<?php echo INSTALLER_PHP; ?>">
		<input type="hidden" name="act" value="dl">
		<input type="hidden" name="dirname" value="<?php echo $_SESSION['dirname']; ?>">
<input type="hidden" name="email" value="hoge@fugo.com">
<input type="hidden" name="password" value="fugofugo">

<input type=submit value="取得 ≫">

		</form>
<?php
}

function showInput(){
	if($_SESSION['dirname'] == '.'){
		$path=str_replace("/".INSTALLER_PHP,"",env('SCRIPT_NAME'));
	}else{
		$path=str_replace("/".INSTALLER_PHP,"",env('SCRIPT_NAME')).'/'.$_SESSION['dirname'];
	}
	if(!env('HTTPS')){
		$siteurl='http://'.env('HTTP_HOST').$path;
	}else{
		$siteurl='https://'.env('HTTP_HOST').$path;
	}

?>

<script type="text/javascript">
<!--
function ChangeSelection(form, selection) {
  form.servername.value = selection.value;
}
//-->
</script>


<h3>管理者ログインパスワード</h3>

<p>
このソフトにログインする際に必要となるパスワードを設定してください。
<br /><br />

		<form method="post" action="<?php echo INSTALLER_PHP; ?>">
		<input type="hidden" name="act" value="setdb">
		<input type="hidden" name="siteurl" value="<?php echo $siteurl ; ?>">

<table>
	<tr>
		<td style="text-align:left;">管理者ログインパスワード：</td>
		<td style="text-align:left;"><input name="loginpassword"><br />半角英数字4～12字で、ご希望のパスワードを設定してください。</td>
	</tr>
<!--
	<tr>
		<td style="text-align:left;">サイトURL：</td>
		<td style="text-align:left;"><input name="siteurl" value="<?php echo $siteurl ; ?>" size=60><br />当システムを設置するURLを記入してください。<br />フォルダ名を変更していない限りは、通常このままで結構です。<br /><br />注意! URLの最後のスラッシュ「/」はいれないでください。<br />例: × http://www.mail-neo.com/neo/<br />　　○ http://www.mail-neo.com/neo</td>
	</tr>
-->
</table>
</p>

<h3>レンタルサーバー情報</h3>

<p>
このソフトを設置するレンタルサーバー、サーバー種別を選択してください。
<br /><br />

<table>
	<tr>
		<td style="text-align:left;">レンタルサーバー：</td>
		<td style="text-align:left;">
<select name=servername_list onChange="ChangeSelection(this.form, this);">
<option value="">選択してください
<option value="CORESERVER(コアサーバー)">CORESERVER(コアサーバー)</option>
</select><input type="text" name="servername" value="" size="30" /><br />
選択肢にご利用のレンタルサーバーがない場合は、名称をご記入ください。
		</td>
	</tr>
	<tr>
		<td style="text-align:left;">サーバー種別：</td>
		<td style="text-align:left;">
<select name="servertype">
<option label="共用サーバ" value="0" selected="selected">共用サーバ</option>
<option label="専用サーバ" value="1">専用サーバ</option>
</select>
		</td>
	</tr>
</table>
</p>

<h3>データベース情報</h3>

<p>
データベースの設定情報を入力してください。
<br /><br />

<table>
	<tr>
		<td style="text-align:left;">①サーバー/ホスト：</td>
		<td style="text-align:left;"><input name="host" value="localhost"><br />ポート番号を指定する場合は「localhost:3306」のように記述してください。</td>
	</tr>
	<tr>
		<td style="text-align:left;">②データベース名：</td>
		<td style="text-align:left;"><input name="database"><br />すでに存在している場合、一旦削除され、新規に作成されます。</td>
	</tr>
	<tr>
		<td style="text-align:left;">③ユーザー名：</td>
		<td style="text-align:left;"><input name="user"><br />データベース作成や権限を与えることができるユーザ名を指定してください。</td>
	</tr>
	<tr>
		<td style="text-align:left;">④上記ユーザーのパスワード：</td>
		<td style="text-align:left;"><input name="password"></td>
	</tr>
</table>
</p>

<input type=submit value="次へ ≫">

		</form>
<?php
}

function stripslashes_deep($value) {
	if (is_array($value)) {
		$return = array_map('stripslashes_deep', $value);
	} else {
		$return = stripslashes($value);
	}
	return $return;
}

function sanitize($value) {
	return htmlspecialchars($value);
}

function makePhpIni($servername){
	if($servername=='CORESERVER(コアサーバー)' || $servername=='XREA'){
		$fp = @fopen($_SESSION['dirname'].'/php.ini', 'w');
		fwrite($fp, 'extension_dir = "./"');
		fclose($fp);

		$fp = @fopen($_SESSION['dirname'].'/test/php.ini', 'w');
		fwrite($fp, 'extension_dir = "./"');
		fclose($fp);

		$fp = @fopen($_SESSION['dirname'].'/backend/mail/bin/php.ini', 'w');
		fwrite($fp, 'extension_dir = "./"');
		fclose($fp);
	}
}

class neoinst{
	var $db;

function setDb()
{
	if (ini_get('magic_quotes_gpc') == 1) {
		if(count($_POST)) {
			$params['form'] = stripslashes_deep($_POST);
		}
	} else {
		$params['form'] = $_POST;
	}

	if(!preg_match("/^\w+$/",$params['form']['loginpassword']) || strlen($params['form']['loginpassword'])>12 || strlen($params['form']['loginpassword'])<4)
	{
		showError('管理者ログインパスワードは半角英数字4字から12字までで記入してください。');
		return false;
	}
	if(!preg_match("/^(http|https|mailto):\/\/[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+$/i",$params['form']['siteurl']))
	{
		showError('サイトURLを正しく記入してください。');
		return false;
	}

	if(empty($params['form']['servername']))
	{
		showError('レンタルサーバーを選択してください。');
		return false;
	}

	if($params['form']['servertype']!=0 && $params['form']['servertype']!=1)
	{
		showError('サーバー種別を正しく選択してください。');
		return false;
	}

	$_SESSION['servername']=$params['form']['servername'];
	$_SESSION['servertype']=$params['form']['servertype'];

//	makePhpIni($params['form']['servername']);

	$conn=@mysql_connect($params['form']['host'],$params['form']['user'],$params['form']['password']);
	if(!$conn)
	{
		showError('ホストに接続できませんでした。<br />サーバー/ホスト、ユーザ名、上記ユーザーのパスワードに間違いがないか確認してください。');
		return false;
	}

/*
	if (mysql_select_db($params['form']['database'], $conn)) {
		$query = sprintf("DROP DATABASE %s",mysql_real_escape_string($params['form']['database']));
		if (!@mysql_query($query, $conn)) {
			mysql_close($conn);
			showError('データベースを削除できませんでした。<br />データベースの削除権限のあるユーザ名を入力してください。');
			return false;
		}
	}

	$query = sprintf("CREATE DATABASE %s",mysql_real_escape_string($params['form']['database']));
	if (!@mysql_query($query, $conn)) {
		mysql_close($conn);
		showError('データベースを作成できませんでした。<br />データベースの作成権限のあるユーザ名を入力してください。');
		return false;
	}

	if (!mysql_select_db($params['form']['database'], $conn)) {
		mysql_close($conn);
		showError('データベースに接続できませんでした。<br />サーバー/ホスト、ユーザ名、上記ユーザーのパスワード、データベース名に間違いがないか確認してください。');
		return false;
	}
*/

	$query = "SELECT VERSION();";
	$re=@mysql_query($query, $conn);
	if(!$re)
	{
		showError("SQL実行時に問題が発生しました。<br /><br />(<small>" . htmlspecialchars($query) . "</small>)");
		mysql_close($conn);
		return false;
	}
	$mysql_version=mysql_result($re, 0);
	$match = explode('.', $mysql_version);
	$mysql_int_version = (int) sprintf('%d%02d', $match[0], $match[1]);

	if($mysql_int_version>400)
	{
		$query="SET NAMES utf8";
		$re=@mysql_query($query);
		if(!$re)
		{
			showError("SQL実行時に問題が発生しました。<br /><br />(<small>" . htmlspecialchars($query) . "</small>)");
			mysql_close($conn);
			return false;
		}
	}

	if (!mysql_select_db($params['form']['database'], $conn)) {
		$query = sprintf("CREATE DATABASE `%s`;",mysql_real_escape_string($params['form']['database']));
		if (!@mysql_query($query, $conn)) {
			showError('データベースを作成できませんでした。<br />データベースの作成権限のあるユーザ名を入力してください。');
			mysql_close($conn);
			return false;
		}

		if (!mysql_select_db($params['form']['database'], $conn)) {
			showError('データベースに接続できませんでした。<br />サーバー/ホスト、データベース名、ユーザ名、上記ユーザーのパスワードに間違いがないか確認してください。');
			mysql_close($conn);
			return false;
		}

	}else{
		$query = sprintf("DROP DATABASE `%s`;",mysql_real_escape_string($params['form']['database']));
		if (!@mysql_query($query, $conn)) {
			$query = sprintf("SHOW TABLES FROM `%s`;",mysql_real_escape_string($params['form']['database']));
			$result=mysql_query($query, $conn);
			if (!$result) {
				showError('テーブルリストを取得できませんでした。<br />データベースにアクセス権限のあるユーザ名を入力してください。');
				mysql_close($conn);
				return false;
			}
			$tables=array();
			while ($row = mysql_fetch_row($result)) {
				$tables[] = '`'.mysql_real_escape_string($row[0]).'`';
			}
			$query = "DROP TABLE IF EXISTS ".join(' , ', $tables).";";
			if (!@mysql_query($query, $conn)) {
				showError('テーブルを削除できませんでした。<br />データベースの削除権限のあるユーザ名を入力してください。');
				mysql_close($conn);
				return false;
			}
		}else{
			$query = sprintf("CREATE DATABASE `%s`;",mysql_real_escape_string($params['form']['database']));
			if (!@mysql_query($query, $conn)) {
				showError('データベースを作成できませんでした。<br />データベースの作成権限のあるユーザ名を入力してください。');
				mysql_close($conn);
				return false;
			}

			if (!mysql_select_db($params['form']['database'], $conn)) {
				showError('データベースに接続できませんでした。<br />サーバー/ホスト、データベース名、ユーザ名、上記ユーザーのパスワードに間違いがないか確認してください。');
				mysql_close($conn);
				return false;
			}
		}
	}

	$this->db=new database($params['form']['host'],$params['form']['user'],$params['form']['password']);

	if($mysql_int_version>400){
		@unlink($_SESSION['dirname'].'/'.SQLDIR.'/init.sql');
	}else{
		@unlink($_SESSION['dirname'].'/'.SQLDIR.'/init_41.sql');
	}
	$files=scanEntireDir($_SESSION['dirname'].'/'.SQLDIR);
	sort($files);
	foreach($files as $file){
		if ( (!strcmp($file, '.')) OR (!strcmp($file, '..')) ) continue;
		$filename = $_SESSION['dirname'].'/'.SQLDIR.'/'.$file;

		if(substr($file,-3)=='sql'){
			$fd = fopen ($filename, "r");
			$queries = fread ($fd, filesize ($filename));
			fclose ($fd);
			$queries = split("(;\n|;\r)",$queries);

			foreach($queries as $query)
			{
				$query = trim($query);
				if ($query)
				{
					if(preg_match("/^--/",$query))
					{
						continue;
					}
					$query=@preg_replace("/--[^\n]+\n/","\n",$query);
					$re=@mysql_query($query);
					if(!$re)
					{
						showError("SQL実行時に問題が発生しました。<br /><br />(<small>" . htmlspecialchars($query) . "</small>)");
						mysql_close($conn);
						return false;
					}
				}
			}
		}else if(substr($file,-3)=='php'){
			include($filename);
		}
	}

	$query = sprintf("insert into configs(sitename, siteurl, loginpassword, " .
			"sender_ln, sender_cmd, regist_cmd, servername, servertype) " .
			"values('%s','%s','%s','%s','%s','%s','%s','%s');",
		mysql_real_escape_string('MY NEO 独自メール配信ソフト'),
    mysql_real_escape_string($params['form']['siteurl']),
    mysql_real_escape_string($params['form']['loginpassword']),
    mysql_real_escape_string(get_php_path()),
    mysql_real_escape_string(get_sender_path()),
    mysql_real_escape_string(get_register_path()),
    mysql_real_escape_string($params['form']['servername']),
    mysql_real_escape_string($params['form']['servertype']));
	$re=@mysql_query($query);
	if(!$re)
	{
		showError('データベースに管理者ログインパスワード、サイトURLを登録できませんでした。');
		return false;
	}

	mysql_close($conn);

	$configWritten = 0;
	$filename =$_SESSION['dirname'].'/'.DBCONFFILE;
	if (@file_exists($filename) && is_writable($filename) && $fp = @fopen($filename, 'w'))
	{
		$config_data = "<" . "?php \n";
		$config_data .= "\n";
		$config_data .= "class DATABASE_CONFIG\n";
		$config_data .= "{\n";
		$config_data .= "	var \$default = array(\n";
		$config_data .= "		'driver' => 'mysql',\n";
		$config_data .= "		'connect' => 'mysql_connect',\n";
		$config_data .= "		'host' => '".$params['form']['host']."',\n";
		$config_data .= "		'login' => '".$params['form']['user']."',\n";
		$config_data .= "		'password' => '".$params['form']['password']."',\n";
		$config_data .= "		'database' => '".$params['form']['database']."' \n";
		$config_data .= "	);\n";
		$config_data .= "}\n";
		$config_data .= "?" . ">";

		$result = @fputs($fp, $config_data, strlen($config_data));
		fclose($fp);
		if ($result)
		{
			$configWritten = 1;
		}
	}

	if(!$configWritten)
	{
		showError('設定をファイルに書き込めませんでした。<br>'.$_SESSION['dirname'].'/'.DBCONFFILE.' が存在していてパーミッションが666か確認してください。');
		return false;
	}
	chmod($_SESSION['dirname'].'/'.DBCONFFILE, 0644);
	return true;
}
}

function get_sender_path() {
	if(isset($_SESSION['cp_bin_file']) && $_SESSION['cp_bin_file']==1){
		if($_SESSION['dirname'] == '.'){
			return dirname(__FILE__).'/backend/mail/bin/sender.php';
		}else{
			return dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/sender.php';
		}
	}else{
		if($_SESSION['dirname'] == '.'){
			return dirname(__FILE__).'/backend/mail/bin/sender.cgi';
		}else{
			return dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/sender.cgi';
		}
	}
}

function get_register_path() {
	if(isset($_SESSION['cp_bin_file']) && $_SESSION['cp_bin_file']==1){
		if($_SESSION['dirname'] == '.'){
			return dirname(__FILE__).'/backend/mail/bin/regist.php';
		}else{
			return dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/regist.php';
		}
	}else{
		if($_SESSION['dirname'] == '.'){
			return dirname(__FILE__).'/backend/mail/bin/regist.cgi';
		}else{
			return dirname(__FILE__).'/'.$_SESSION['dirname'].'/backend/mail/bin/regist.cgi';
		}
	}
}

function env($key) {
	if ($key == 'HTTPS') {
		if (isset($_SERVER) && !empty($_SERVER)) {
			return (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on');
		} else {
			return (strpos(env('SCRIPT_URI'), 'https://') === 0);
		}
	}

	if (isset($_SERVER[$key])) {
		return $_SERVER[$key];
	} elseif (isset($_ENV[$key])) {
		return $_ENV[$key];
	} elseif (getenv($key) !== false) {
		return getenv($key);
	}

	if ($key == 'DOCUMENT_ROOT') {
		$offset = 0;
		if (!strpos(env('SCRIPT_NAME'), '.php')) {
			$offset = 4;
		}
		return substr(env('SCRIPT_FILENAME'), 0, strlen(env('SCRIPT_FILENAME')) - (strlen(env('SCRIPT_NAME')) + $offset));
	}
	if ($key == 'PHP_SELF') {
		return r(env('DOCUMENT_ROOT'), '', env('SCRIPT_FILENAME'));
	}
	return null;
}

function get_php_path() {
	$patharr=array();
	$re = trim(exe('whereis php'));
	if(!empty($re)){
		$paths=split(' ',$re);
		if(!empty($paths)){
			foreach($paths as $path){
				$path=strtolower($path);
				if(substr($path,-4)==DS.'php' && strpos($path,DS.'bin'.DS)!==false){
					$patharr[]=$path;
				}
			}
		}
	}
	if(empty($patharr)){
		return '/usr/local/bin/php';
	}else{
		if(in_array('/usr/local/bin/php',$patharr)){
			return '/usr/local/bin/php';
		}else{
			return $patharr[0];
		}
	}
}

function showEnd(){
?>

<h3>インストール完了</h3>

システムのインストールが完了しました。
<br /><br />

安全な利用のため、以下の処理を行ってください。
<br /><br />

<ul>
<li><?php echo INDEX_HTML; ?>は、サーバ上から削除してください。
<li>このファイル (<?php echo dirname(__FILE__).'/'.INSTALLER_PHP; ?>) は、サーバー上から削除してください。
<li>ディレクトリ (<?php echo dirname(__FILE__).'/'.$_SESSION['dirname']; ?>) のパーミッションを 755 にしてください。777 のままですと、サーバーによっては、NEOにアクセスできません。
</ul>
<br /><br />

上記の処理が終わったら、<a href="<?php echo sanitize($_POST['siteurl']); ?>" target="_blank">こちらのページより、さきほど設定した管理者ログインパスワードでログインしてください。</a>
<br /><br />

<?php
}

function showLoderErr(){
	$os_name = substr(php_uname(),0,strpos(php_uname(),' '));
	$os_code = strtolower(substr($os_name,0,3));
	$os_info = php_uname();
	$php_version = phpversion();
	$php_flavour = substr($php_version,0,3);

	if($os_code=='lin' || $os_code=='dra' || $os_code=='bsd' || $os_code=='net' || $os_code=='sun'){
		$default_loader=$os_name.' (x86)';
	}else if($os_code=='fre'){
		$default_loader='FreeBSD 4 (x86)';
	}else if($os_code=='ope'){
		$default_loader='OpenBSD 3.8 (x86)';
	}else if($os_code=='dar'){
		$default_loader='MacOS X (ppc)';
	}else{
		$default_loader='Linux (x86)';
	}

?>

<h3>ローダーのインストール</h3>

システムのインストールは完了しましたが、ローダー(暗号化されたプログラムを実行するためのファイル)を変更していただく必要があります。
<br /><br />

ローダーは、サーバーのプラットフォーム(OS)に合わせる必要があり、デフォルトでは<?php echo $default_loader; ?>用のローダーが適用されていますが、このサーバーのプラットフォームとは異なっているようです。
<br /><br />

このサーバの情報は以下となっています。<br />
<fieldset>
プラットフォーム(OS)は「<strong><?php echo $os_name; ?></strong>」<br />
PHPのバージョンは「<strong><?php echo $php_version; ?></strong>」<br />
詳細情報<br />
<strong><?php echo $os_info; ?></strong>
</fieldset>
<br /><br />

以下の一覧のなかから、プラットフォーム(<strong><?php echo $os_name; ?></strong>)、PHPのバージョン(<strong><?php echo $php_version; ?></strong>)が一致するものを探し「ダウンロード」をクリックしてください。<br />
※プラットフォームが同じであっても、数種類のローダーがあります。エラーとなる場合は、別のものを試してみてください。
<br /><br />

<?php showLoaderList(); ?>

問題が解消されない場合、<a href=http://www.mail-neo.com/inquiries/add target="_blank">こちらからお問い合わせください。</a><br />
なお、お問い合わせの際は、このページに表示されているプラットフォーム、PHPのバージョン、詳細情報をあわせてご連絡ください。

<?php
}

function showLoaderList(){
	$os_name = substr(php_uname(),0,strpos(php_uname(),' '));
	$os_code = strtolower(substr($os_name,0,3));
?>
<table class="common-table2">
	<tr align="center">
    	<th>プラットフォーム</th>
     	<th> ローダーのダウンロード</th>
    	<th>PHP バージョン</th>
  </tr>
<?php if($os_code=='lin'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;Linux (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=lin_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;Linux (x86-64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=lin_x86-64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;Linux (ppc)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=lin_ppc" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.1～5.2</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;Linux (ppc64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=lin_ppc64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.1～5.2</td>
	</tr>
<?php elseif($os_code=='dra'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;DragonFly(x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=dra_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.2</td>
	</tr>
<?php elseif($os_code=='fre'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;FreeBSD 4 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=fre_4_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;FreeBSD 6 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=fre_6_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;FreeBSD 6 (x86-64)</td>
	<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=fre_6_x86-64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.2</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;FreeBSD 7 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=fre_7_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;FreeBSD 7 (x86-64)</td>
	<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=fre_7_x86-64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;FreeBSD 8 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=fre_8_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;FreeBSD 8 (x86-64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=fre_8_x86-64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.3</td>
	</tr>
<?php elseif($os_code=='bsd'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;BSDi (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=bsd_x86" target=LD>ダウンロード</a></td>
		<td>4.3～4.4、5.0～5.1</td>
	</tr>
<?php elseif($os_code=='net'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;NetBSD (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=net_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.2</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;NetBSD (x86-64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=net_x86-64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.1</td>
	</tr>
<?php elseif($os_code=='ope'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;OpenBSD 3.7 (x86-64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=ope_3.7_x86-64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.1</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;OpenBSD 3.9 (x86-64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=ope_3.9_x86-64" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.2</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;OpenBSD 3.8 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=ope_3.8_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.2</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;OpenBSD 4.2 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=ope_4.2_x86" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.2</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;OpenBSD 4.5 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=ope_4.5_x86" target=LD>ダウンロード</a></td>
		<td>4.3～4.4、5.1～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;OpenBSD 4.6 (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=ope_4.6_x86" target=LD>ダウンロード</a></td>
		<td>4.3～4.4、5.1～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;OpenBSD 4.7 (x86-64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=ope_4.7_x86-64" target=LD>ダウンロード</a></td>
		<td>4.3～4.4、5.1～5.3</td>
	</tr>
<?php elseif($os_code=='dar'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;MacOS X (ppc)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=dar_ppc" target=LD>ダウンロード</a></td>
		<td>4.1～4.4、5.0～5.2</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;MacOS X (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=dar_x86" target=LD>ダウンロード</a></td>
		<td>4.3～4.4、5.1～5.3</td>
	</tr>
		<td style="text-align: left;">&nbsp;MacOS X (x86-64)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=dar_x86-64" target=LD>ダウンロード</a></td>
		<td>4.3～4.4、5.1～5.3</td>
	</tr>
<?php elseif($os_code=='sun'): ?>
	<tr>
		<td style="text-align: left;">&nbsp;Solaris (sparc)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=sun_sparc" target=LD>ダウンロード</a></td>
		<td>4.2～4.4、5.0～5.3</td>
	</tr>
	<tr>
		<td style="text-align: left;">&nbsp;Solaris (x86)</td>
		<td><a href="<?php echo INSTALLER_PHP; ?>?act=ld&amp;system=sun_x86" target=LD>ダウンロード</a></td>
		<td>4.3～4.4、5.0～5.3</td>
	</tr>
<?php else: ?>
	<tr>
		<td style="text-align: left;">&nbsp;プラットフォームに対応するローダーがありません。</td>
		<td> - </td>
		<td> - </td>
	</tr>
<?php endif; ?>
</table>

<?php
}

function installLoader($system=null){
	if(empty($system)){
		$os_name = substr(php_uname(),0,strpos(php_uname(),' '));
		$os_code = strtolower(substr($os_name,0,3));

		if($os_code=='lin' || $os_code=='dra' || $os_code=='bsd' || $os_code=='net' || $os_code=='sun'){
			$system=$os_code.'_x86';
		}else if($os_code=='fre'){
			$system='fre_4_x86';
		}else if($os_code=='ope'){
			$system='ope_3.8_x86';
		}else if($os_code=='dar'){
			$system='dar_ppc';
		}else{
			$system='lin_x86';
		}
	}

	$dlurl=sprintf(LOADER_DL_URL,$system);
	$match = explode('.', phpversion());
	$phpver = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));

	if($phpver>=50205){
		exe('rm -f '.$_SESSION['dirname'].'/ioncube_loader_*');
	}else{
		if(file_exists($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR)){
			delTree($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR);
		}
	}

	if(!download($dlurl,$_SESSION['dirname'].'/'.LOADER_TAR_FILE)){
		showError('ファイルのダウンロードに失敗しました。しばらくしてからやりなおしてください。');
		return false;
	}

	if(!file_exists($_SESSION['dirname'].'/'.LOADER_TAR_FILE)){
		showError('ファイルのダウンロードに失敗しました。しばらくしてからやりなおしてください。');
		return false;
	}

	if($_SESSION['dirname'] == '.'){
		$cmd='tar -zxf '.LOADER_TAR_FILE.' '.LOADER_SOURCE_DIR;
		$cmd2='gzip -d '.LOADER_TAR_FILE.'; tar -xf '.LOADER_TAR_FILE2.' '.LOADER_SOURCE_DIR;
	}else{
		$cmd='cd '.$_SESSION['dirname'].'; tar -zxf '.LOADER_TAR_FILE.' '.LOADER_SOURCE_DIR;
		$cmd2='cd '.$_SESSION['dirname'].'; gzip -d '.LOADER_TAR_FILE.'; tar -xf '.LOADER_TAR_FILE2.' '.LOADER_SOURCE_DIR;
	}
	$re=exe($cmd);

	if(!file_exists($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR)){
		$re=exe($cmd2);
		if(!file_exists($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR)){
			showError('ファイルの展開に失敗しました。ファイル取得に失敗した可能性があります。しばらくしてからやりなおしてください。');
			return false;
		}
	}

	@unlink($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.DS.'ioncube-encoded-file.php');
	@unlink($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.DS.'ioncube-loader-helper.php');
	@unlink($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.DS.'loader-wizard.php');

	if($phpver>=50205){
		@rename($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.DS.'LICENSE.txt',$_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.DS.'ioncube_loader_LICENSE.txt');
		@rename($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.DS.'README.txt',$_SESSION['dirname'].'/'.LOADER_SOURCE_DIR.DS.'ioncube_loader_README.txt');

		dircopy($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR,$_SESSION['dirname']);
		delTree($_SESSION['dirname'].'/'.LOADER_SOURCE_DIR);
	}

	@unlink($_SESSION['dirname'].'/'.LOADER_TAR_FILE);
	@unlink($_SESSION['dirname'].'/'.LOADER_TAR_FILE2);
	return true;
}

function showLoderNG(){
?>
<h3>ローダーのインストール失敗</h3>

このローダーではありません。別のものを試してみてください。

<?php
}

function showLoderOK(){
?>
<h3>ローダーのインストール完了</h3>

正しいローダーに変更しました。
<br /><br />

安全な利用のため、以下の処理を行ってください。
<br /><br />

<ul>
<li><?php echo INDEX_HTML; ?>は、サーバー上から削除してください。
<li>このファイル (<?php echo dirname(__FILE__).'/'.INSTALLER_PHP; ?>) は、サーバー上から削除してください。
<li>ディレクトリ (<?php echo dirname(__FILE__).'/'.$_SESSION['dirname']; ?>) のパーミッションを 755 にしてください。777 のままですと、サーバーによっては、NEOにアクセスできません。
</ul>
<br /><br />

上記の処理が終わったら、<a href="<?php echo ($_SESSION['dirname']=='.'?'':($_SESSION['dirname'].'/')); ?>" target="_blank">こちらのページより、さきほど設定した管理者ログインパスワードでログインしてください。</a>
<br /><br />

<?php
}

function touchVerup() {
	$filename =$_SESSION['dirname'].'/'.VERFILE;
	if ($fp = @fopen($filename, 'w'))
	{
		$config_data = date("Y-m-d");
		$result = @fputs($fp, $config_data, strlen($config_data));
		fclose($fp);
	}
}

class database{
	var $conn;
	var $host;
	var $user;
	var $password;

	function database($host,$user,$password){
		$this->host=$host;
		$this->user=$user;
		$this->password=$password;

		$this->connect();
	}

	function connect(){
		$this->conn=@mysql_connect($this->host,$this->user,$this->password);
		if(!$this->conn){
			return false;
		}
		return true;
	}

	function checkVersion(){
		if(defined('_MYSQL_INT_VERSION')){
			return true;
		}
		$query = "SELECT VERSION();";
		$re=@mysql_query($query, $this->conn);
		if(!$re){
			return false;
		}
		$mysql_version=mysql_result($re, 0);
		$match = explode('.', $mysql_version);
		$mysql_int_version = (int) sprintf('%d%02d%02d', $match[0], $match[1], intval($match[2]));
		define('_MYSQL_INT_VERSION',$mysql_int_version);

		if($mysql_int_version>400){
			$query="SET NAMES utf8";
			$re=@mysql_query($query);
			if(!$re){
				return false;
			}
		}
		return true;
	}

	function execute($sql) {
		return mysql_query($sql, $this->conn);
	}

	function findAll($query) {
		$re=$this->execute($query);
		if(!$re)
		{
			return null;
		}
		return $this->fetchAssoc($re);
	}

	function fetchAssoc($result=null) {
		$resultRow = array();
		while ($row = mysql_fetch_assoc($result)) {
			$resultRow[]=$row;
		}
		return !count($resultRow)?null:$resultRow;
	}
}

function exe($cmd){
	static $exeflag=null;

	if($exeflag===null){
		$re=shell_exec('ls -al');
		$re=trim($re);
		if(!empty($re)){
			$exeflag=1;
		}else{
			exec('ls -al',$re);
			if(is_array($re)){ $re=join("\n",$re); }
			$re=trim($re);
			if(!empty($re)){
				$exeflag=2;
			}else{
				$re=system('ls -al');
				$re=trim($re);
				if(!empty($re)){
					$exeflag=3;
				}else{
					$exeflag=99;
				}
			}
		}
	}

	if($exeflag==1){
		return trim(shell_exec($cmd));
	}elseif($exeflag==2){
		exec($cmd,$re);
		if(is_array($re)){ $re=join("\n",$re); }
		return trim($re);
	}elseif($exeflag==3){
		return trim(system($cmd));
	}
	return false;
}
?>
